const express = require("express");
const mysqlConnection = require("../utils/database");
const { loginHandler, loginHandlerA, checkSupperAdmin, Checkuserauth } = require('../Controller/LoginScema');
const { MenuItems } = require("../Controller/ManueItems");
const { Dropdown } = require("../Controller/ManueItems");
const { Userpermission, GetAllPermission } = require("../Controller/Userpermission");
const { DropDown } = require("../Controller/DropDown");
const { ForgetPassword, ResetPassword } = require("../Controller/ForgetPassword");
const { getPersonalInfoHandler, updatePersonalInfoHandler, getPersonalInfoHandlerbyId } = require("../Controller/Personalinfo");
const { UserDetails, createUserDetails, updateUserDetails } = require("../Controller/User_details/UserDetails");
const { UserLogs, GetUserLogs } = require("../Controller/logs/UserLogs");
const { AllEmployees, SpecificEmp } = require("../Controller/Employees/AllEmployees");
const { EmpOffice } = require("../Controller/Employees/EmpOffice");
const { getAllCompany, GetCompanies, GetSingleCompany } = require("../Controller/SupperAdmin/Getcompany");
const { DeleteEmployee } = require("../Controller/Employees/DeleteEmployee");
const { EmpgetPersonalInfo, EmpUpdatePersonalInfo } = require("../Controller/EditEmployInfo/PersonalInfoma");
const { EmployeeDetails, UpdateEmployeeDetails, CreateEmployeeDetails } = require("../Controller/EditEmployInfo/EmployeeDetails");
const { EmpOfficeDetails, AllDays, UpdateEmpOfficeandjobDetails, CreateEmpOfficeJobDetails, AllOffices } = require("../Controller/EditEmployInfo/EmployeeJobInfo");
const { GetEmployeeContectInfo, GetContracts, UpdateEmpContectInfo, CreateEmpJobInfo } = require("../Controller/EditEmployInfo/EmployeeContect");
const { GetEmployeeSalaryInfo, GetRupeOrPer, UpdateEmpSalaryInfo, CreateEmpSalaryInfo } = require('../Controller/EditEmployInfo/EmpSalaryInfo');
const { GetDessignation, GetDepartment, GetUserType, CreateUser } = require("../Controller/EditEmployInfo/AddNewEmployee");
const { UpdateVaultInfo } = require("../Controller/EditEmployInfo/VaultInfo");
const { GetEmpStatus, UpdateStatusInfo } = require("../Controller/EditEmployInfo/Sms_LeadStatus");
const { All_lables, userPermission, TotalLead, UnaginedLead, All_labels, All_labelsForMember } = require("../Controller/LeadM/Card-leadsLable");
const { Highly_interested, highly_interested_table, GetLeadFromId, AllCustomers, HeaderLabel, SpecificTeamMemberLeads } = require("../Controller/LeadM/highly_interested");
const { CreateComments, GetComments, DeleteComments, AllLabels, SelectForBox, UpdateLabel, SaveTime, GetFollowup, CreateActivityReport, DoneFollowUps, markFollowUpAsRead } = require("../Controller/LeadM/Comments");
const { ClosedLeadController, ViewLead } = require("../Controller/LeadM/closeLeads");
const { EditLeadCustomer, UpdateLeadCustomer, GetCountrycode, CreateLeadCustomer, GetCustomerById } = require("../Controller/LeadM/EditLeadCustomer");
const { ZoneData, GetTeamMemeber, UpdateZoneTeam, TeamData, GetzoneMemeber, ZoneTeamData, CreateZoneTeam, GetSpecificZone } = require("../Controller/Team&Zones/zones");
const { Getteamates, TeamForEmployee, UpdateTeamForEmployee, AddTeamMember, GetSpecificteam } = require("../Controller/Team&Zones/Team");
const { AllFloors, projectData, GetStatus, CreateNewProject, GetProjectDetails, UpdateProject, GetProjects, FloorsData, ManageUnits, NewFloor, UpdateProjectFloor } = require("../Controller/Project/project");
const { ReassinedLead } = require("../Controller/LeadM/ReassignedLead");
const { SignUpHandler, OnBordingHandler } = require("../Controller/Signup");
const { customMiddleware } = require("../Controller/middleware/middleware");
const { getCounts, getTopLead } = require("../Controller/Dashboard/Dashboard");
const { GetSourceDepInterestLeadtype, CreateNewLead } = require("../Controller/LeadM/NewLead");
// const { GetSourceDepInterestLeadtype, CreateNewLead, facebookLeads } = require("../Controller/LeadM/NewLead");
const { NewNotification, GetNotification, updateNotificationMark, saveSubscription, markNotificationAsRead, deleteNotification, getNotificationHistory, clearAllNotifications } = require("../Controller/Dashboard/Notification");
const { AddNewFloor, UpdateUnits, CreateNewUnits, UnitCounts, AddDuplicateFloor, DeleteProjectFloor, UpdateAllFloorRates, Getrequiredfloor, UpdateImage, GetImg, SaveMapUnits, GetMapUnits } = require("../Controller/Project/floor");
const { createNewPaymentPlan, paymentData, GetSpecificPyammentplan, DeletePaymentplan, LinkProject, GetPaymentPlan, GetTemplates, GetTemplatesUnits, GetPaymentPlanid, UpdatePaymentPlan } = require("../Controller/Project/pamymentplain");
const { DailyReport, fullReport } = require("../Controller/LeadM/DailyReport");
const { createRealtorProfile, updateRealtorProfile, deleteRealtorProfile, getRealtorProfileById, getAllRealtorProfiles, getRealtorProfileByUser } = require("../Controller/Realtor/RealtorController");
const { getMonthlyTargetById, listMonthlyTargets, CreateTargetRevenue, MonthlyTargets } = require("../Controller/LeadM/RevenueTargets");
const { verifyToken } = require("../middleware/jwtMiddleware");
const { createCallLog, updateCallLog, addCallRecording } = require('../Controller/logs/CallLogs');
const { checkFollowUpReminders } = require('../Controller/FollowUpReminders');
const { saveExpoPushToken, deleteExpoPushToken } = require('../Controller/Dashboard/ExpoNotification');
const UnifiedNotificationService = require('../services/NotificationService');
const FCMNotificationService = require('../services/FCMNotificationService');



const Router = express.Router();



Router.post('/api/login', loginHandler);
Router.post('/api/login-a', loginHandlerA);
Router.post('/api/signup', SignUpHandler);
Router.get('/api/supperadmin/:email', checkSupperAdmin)
Router.post('/api/onboarding/:email', OnBordingHandler)
Router.get('/api/items', MenuItems)
Router.get('/api/dropdown/:parent_id', DropDown)
Router.get('/api/permission/:email', Userpermission)

Router.get('/api/me', verifyToken, Checkuserauth);
//dashboard getCounts

Router.get('/api/total-items', getCounts)
Router.get('/api/top-leads', getTopLead)

//all Notifications
Router.post('/api/sendNotification', NewNotification)
Router.post('/api/subscribe/:email', saveSubscription)
Router.get('/api/getNotification/:email', GetNotification)
Router.put('/api/markNotificationAsRead/:notificationId', updateNotificationMark)
Router.get('/check-followup-reminders', checkFollowUpReminders)

// Notification management endpoints
Router.patch('/api/notifications/:notificationId', markNotificationAsRead)
Router.delete('/api/notifications/:notificationId', deleteNotification)
Router.get('/api/notifications/history/:userId', getNotificationHistory)
Router.delete('/api/notifications/history/:userId', clearAllNotifications)

// Expo Push Notifications (React Native)
Router.post('/api/expo-token', saveExpoPushToken)
Router.delete('/api/expo-token/:userId', deleteExpoPushToken)

// Unified Notification API Endpoints
Router.post('/api/notifications/send-lead', async (req, res) => {
  try {
    const { userId, username, leadData } = req.body;
    if (!userId || !username || !leadData) {
      return res.status(400).json({ success: false, message: 'Missing required fields' });
    }
    const result = await UnifiedNotificationService.sendLeadNotification(userId, username, leadData);
    res.json(result);
  } catch (error) {
    res.status(500).json({ success: false, error: error.message });
  }
});

Router.post('/api/notifications/send-followup', async (req, res) => {
  try {
    const { userId, username, followUpData } = req.body;
    if (!userId || !username || !followUpData) {
      return res.status(400).json({ success: false, message: 'Missing required fields' });
    }
    const result = await UnifiedNotificationService.sendFollowUpNotification(userId, username, followUpData);
    res.json(result);
  } catch (error) {
    res.status(500).json({ success: false, error: error.message });
  }
});

Router.get('/api/notifications/history/:userId', async (req, res) => {
  try {
    const { userId } = req.params;
    const limit = req.query.limit || 20;
    const result = await UnifiedNotificationService.getNotificationHistory(userId, limit);
    res.json(result);
  } catch (error) {
    res.status(500).json({ success: false, error: error.message });
  }
});

Router.get('/api/personalinfo/:email', getPersonalInfoHandler)
Router.get('/api/personalinfo-by-id/:id', getPersonalInfoHandlerbyId)
Router.put('/api/personalinfo/:email', updatePersonalInfoHandler)
Router.put('/api/forget-password/:email', ForgetPassword)
Router.put('/api/reset-password/', ResetPassword)
Router.get('/api/user-details/:email', UserDetails)
Router.post('/api/create_details', createUserDetails)
Router.put('/api/update_details/:email', updateUserDetails)
//create and get logs
Router.post('/api/logs', UserLogs)
Router.get('/api/logs/:email', GetUserLogs)
//get all employees form the table.
Router.get('/api/employees', AllEmployees)
Router.get('/api/employees-dashbord', SpecificEmp)
Router.get('/api/office/:email', EmpOffice);
//delete the del i Mean change from N to Y
Router.put('/api/del/:id', DeleteEmployee);

//Employe Basic information
Router.get('/api/emp-personalinfo/:id', EmpgetPersonalInfo)
Router.put('/api/emp-personaleinfo/:id', EmpUpdatePersonalInfo)
//Employee personal information
Router.put('/api/update-employye-details/:id', UpdateEmployeeDetails)
Router.get('/api/get-employee-details/:id', EmployeeDetails)
Router.post('/api/create-employee-details', CreateEmployeeDetails)
Router.get('/api/employee-office/:id', EmpOfficeDetails);
//update employee job details
Router.put('/api/update-employee-office-job/:id', UpdateEmpOfficeandjobDetails);
//create employee job details
Router.post('/api/create-employee-office-job/:id', CreateEmpOfficeJobDetails);
//Employee Contect Details
Router.get('/api/employee-contect-info/:id', GetEmployeeContectInfo);
Router.put('/api/update_employee-contect-info/:id', UpdateEmpContectInfo);
Router.post('/api/create-employee-contect-info/:id', CreateEmpJobInfo);



//Employee salary salary info UpdateEmpSalaryInfo
Router.get('/api/employee-salary-info/:id', GetEmployeeSalaryInfo);
Router.put('/api/update_employee-salary-info/:id', UpdateEmpSalaryInfo);
Router.post('/api/create-employee-salary-info/:id', CreateEmpSalaryInfo);
//Update Employee VaultInfo

Router.put('/api/update_employee-vault-info/:id', UpdateVaultInfo);
//get emp status info
Router.get('/api/employee-status-info/:id', GetEmpStatus);
Router.put('/api/update_employee-status-info/:id', UpdateStatusInfo);
//********************************************************* */
//                 Lead Management 
//********************************************************* */
//All lables
Router.get('/api/lables/:email', All_labels);
Router.get('/api/lables-member/:id', All_labelsForMember);
Router.get('/api/userpermission/:email', userPermission);
//total lead
Router.get('/api/leads', TotalLead);
//total unsigned lead
Router.get('/api/unsign-leads', UnaginedLead);
//highly interested
Router.get('/api/highly-interested', Highly_interested);
Router.get('/api/highly-interested-tabel/:id', highly_interested_table);
Router.get('/api/specific-team-member-tabel/:id/:id1', SpecificTeamMemberLeads);
Router.get('/api/header-label/:id', HeaderLabel);
Router.get('/api/all-customers/:user', AllCustomers);
Router.get('/api/get-highlyinterest-by-id/:id', GetLeadFromId);
Router.put('/api/update-assined-lead', ReassinedLead);

//geeting the specific customer
Router.get('/api/edit-customer/:id', EditLeadCustomer)
Router.put('/api/update-customer/:id', UpdateLeadCustomer)
Router.post('/api/new-lead-customer', CreateLeadCustomer)
Router.get('/api/get-customer-by-id/:id', GetCustomerById);
//new leads
Router.post('/api/create-new-lead', CreateNewLead)
//save time for the lead
Router.post('/api/page-time', SaveTime)
// Call logging
Router.post('/api/call-log', createCallLog);
Router.put('/api/call-log/:id', updateCallLog);
Router.put('/api/call-log/:id/recording', addCallRecording);


//comments
Router.post('/api/comments/:id', CreateComments);
Router.post('/api/activity-reports', CreateActivityReport);
Router.get('/api/show-comments/:id', GetComments);
Router.get('/api/follow-up/:user', GetFollowup);
Router.put('/api/delete-comments/:id', DeleteComments);
Router.put('/api/update-followup/:id', DoneFollowUps);
Router.put('/api/mark-followup-read/:id', markFollowUpAsRead);
Router.get('/api/label/:id', SelectForBox);
Router.put('/api/lead-label/:id', UpdateLabel)
Router.post('/api/close-lead/:id', ClosedLeadController);
Router.put('/api/lead-open/:id', ViewLead)

//Team And Zones
Router.get('/api/zones/:email', ZoneData);
Router.get('/api/specific-zoon', GetSpecificZone);
Router.get('/api/specific-team', GetSpecificteam);
Router.get('/api/teams/:email', TeamData);
Router.get('/api/zone-team/:id', ZoneTeamData);
Router.put('/api/zones-teams/:id', UpdateZoneTeam)
Router.get('/api/teamates/:id', Getteamates);
Router.put('/api/update-employee-team/:id', UpdateTeamForEmployee);
Router.post('/api/add-to-new-team/:id', UpdateZoneTeam)
Router.post('/api/create-zone-team/', CreateZoneTeam)
//edit project floor
Router.put('/api/update-project-floor', UpdateProjectFloor);

//Project details 
Router.get('/api/projects', GetProjects);
Router.get('/api/project-data', projectData);
Router.get('/api/floors-data', FloorsData);
Router.get('/api/floors-units', ManageUnits);
Router.post('/api/create-new-project', CreateNewProject);
Router.get('/api/get-project/:id', GetProjectDetails);
Router.put('/api/update-project/:id', UpdateProject);
//floor data
Router.get('/api/floors-map-data', GetImg);
Router.post('/api/shapes', SaveMapUnits);
Router.get('/api/shapes', GetMapUnits);

Router.put('/api/floor-status-update', UpdateUnits);
Router.post('/api/floor-units', CreateNewUnits);
Router.put('/api/upload-floor-image', UpdateImage);
//updates all units

Router.put('/api/floor-rates-update', UpdateAllFloorRates);



//Payment Plan      
Router.post('/api/new-payment-plan', createNewPaymentPlan);
Router.get('/api/payment-data', paymentData);
Router.get('/api/specific-payment', GetSpecificPyammentplan);
Router.delete('/api/delete-paymentplan/', DeletePaymentplan);
Router.put('/api/link-project/', LinkProject);
Router.get('/api/payment-templates', GetPaymentPlan);
Router.get('/api/all-tamplete', GetTemplates);
Router.get('/api/templete-units-data', GetTemplatesUnits);
Router.get('/api/PaymentPlanid', GetPaymentPlanid);
Router.put('/api/edit-payment-plan', UpdatePaymentPlan);







//Supper admin
Router.get('/api/supper-admin/:email', getAllCompany)

//create a new user

Router.post('/api/create-new-user', CreateUser)

//get all users permission 
Router.get('/api/all-permission/:email', GetAllPermission);

//get all days for drop down
Router.get('/api/alldays/', AllDays);
//get all offices for drop down
Router.get('/api/drop-down-oficess/', AllOffices);
//get all contract for drop down
Router.get('/api/allcontract/', GetContracts);
//get Rs or per
Router.get('/api/rs-pr/', GetRupeOrPer);
//all labels
Router.get('/api/all-labels/', AllLabels);
//get country code
Router.get('/api/all-contrycode/', GetCountrycode);
//get all the members
Router.get('/api/all-members/', GetTeamMemeber);
//add team members
Router.put('/api/add-team-member/:id', AddTeamMember);
Router.get('/api/all-teams', GetzoneMemeber);
//select companies
Router.get('/api/select-company', GetCompanies);
Router.get('/api/single-company', GetSingleCompany);

//get all users_designations
Router.get('/api/alldesignation/', GetDessignation);
//get all departments
Router.get('/api/alldeprtment/', GetDepartment);
Router.get('/api/allresource/', GetSourceDepInterestLeadtype);
Router.get('/api/units-count/', UnitCounts);
Router.get('/api/project-status/', GetStatus);
Router.get('/api/all-floors/', AllFloors);
Router.post('/api/new-floor/', NewFloor);
Router.post('/api/create-new-floor/', AddNewFloor);
Router.post('/api/create-duplicate-floor/', AddDuplicateFloor);
Router.delete('/api/delete-floor/', DeleteProjectFloor);
Router.get('/api/floorName/', Getrequiredfloor);
//get all user type
Router.get('/api/all-user-type/', GetUserType);
//get team for Employee 
Router.get('/api/emp-team/', TeamForEmployee);
// Router.post('/fbleads/', facebookLeads);



//Daily Activity Report
Router.get('/api/daily-activity-report/:user', DailyReport)
Router.get('/api/full-daily-activity-report', fullReport)

// revenue targets
Router.get('/api/revenue-targets/:id', getMonthlyTargetById);
Router.get('/api/revenue-targets', listMonthlyTargets);
Router.put('/api/update-target-revenue', CreateTargetRevenue);
Router.get('/api/revenue-targets-dashbrod', MonthlyTargets);


// dealor register
Router.post('/api/business-profiles', createRealtorProfile);

// Update
Router.put('/api/business-profiles/:id', updateRealtorProfile);

// Delete
Router.delete('/api/business-profiles/:id', deleteRealtorProfile);

// Get single
Router.get('/api/business-profiles/:user', getRealtorProfileByUser);
Router.get('/api/business-profiles-id/:id', getRealtorProfileById);

// Get all (with optional ?q&limit&offset)
Router.get('/api/business-profiles', getAllRealtorProfiles);

// Get by company (with optional ?q&limit&offset)
// Router.get('/business-profiles/company/:companyId', getProfilesByCompany);

// TEST: Send test notification to a user
Router.post('/api/test-notification', async (req, res) => {
  try {
    const { userId, username, title, body, leadId } = req.body;

    if (!userId || !username) {
      return res.status(400).json({
        success: false,
        message: 'userId and username are required'
      });
    }

    const notificationData = {
      title: title || 'Test Notification',
      body: body || 'This is a test notification',
      leadId: leadId || 1,
      type: 'test',
    };

    console.log('📧 [TEST] Sending test notification:', { userId, username, notificationData });

    const result = await UnifiedNotificationService.sendSocketIONotification(userId, notificationData);

    res.json({
      success: true,
      message: 'Test notification sent',
      data: result
    });
  } catch (error) {
    console.error('❌ Test notification error:', error);
    res.status(500).json({ success: false, error: error.message });
  }
});

// ========== FCM NOTIFICATION ENDPOINTS ==========

// Register device token for FCM
Router.post('/api/fcm/register-token', async (req, res) => {
  try {
    const { userId, token, platform = 'web' } = req.body;

    if (!userId || !token) {
      return res.status(400).json({
        success: false,
        message: 'userId and token are required'
      });
    }

    const result = await FCMNotificationService.registerDeviceToken(userId, token, platform);
    res.json(result);
  } catch (error) {
    console.error('❌ Error registering FCM token:', error);
    res.status(500).json({ success: false, error: error.message });
  }
});

// Send FCM notification to user
Router.post('/api/fcm/send', async (req, res) => {
  try {
    const { userId, title, body, leadId, type = 'notification' } = req.body;

    if (!userId || !title || !body) {
      return res.status(400).json({
        success: false,
        message: 'userId, title, and body are required'
      });
    }

    const notification = {
      title,
      body,
      leadId: leadId || null,
      userId,
      type,
    };

    const result = await FCMNotificationService.sendToUser(userId, notification);
    res.json(result);
  } catch (error) {
    console.error('❌ Error sending FCM notification:', error);
    res.status(500).json({ success: false, error: error.message });
  }
});

// Get notification history
Router.get('/api/fcm/history/:userId', async (req, res) => {
  try {
    const { userId } = req.params;
    const limit = req.query.limit || 20;

    const result = await FCMNotificationService.getHistory(userId, limit);
    res.json(result);
  } catch (error) {
    console.error('❌ Error fetching notification history:', error);
    res.status(500).json({ success: false, error: error.message });
  }
});

// Cleanup old FCM tokens (call periodically)
// Get FCM token from backend (Backend-centric approach - NO Firebase Installations API)
Router.post('/api/fcm/get-token', async (req, res) => {
  try {
    const { userId } = req.body;

    if (!userId) {
      return res.status(400).json({ success: false, error: 'userId required' });
    }

    // Generate a unique device token for this user
    const token = `web_${userId}_${Date.now()}_${Math.random().toString(36).substr(2, 9)}`;

    // Register token in database
    await FCMNotificationService.registerDeviceToken(userId, token, 'web');

    console.log(`✅ FCM Token generated for user ${userId}`);

    res.json({
      success: true,
      token: token,
      message: 'Token generated successfully'
    });
  } catch (error) {
    console.error('❌ Error generating FCM token:', error);
    res.status(500).json({ success: false, error: error.message });
  }
});

// Cleanup old FCM tokens
Router.post('/api/fcm/cleanup', async (req, res) => {
  try {
    const daysOld = req.body.daysOld || 30;
    const result = await FCMNotificationService.cleanupOldTokens(daysOld);
    res.json(result);
  } catch (error) {
    console.error('❌ Error cleaning up FCM tokens:', error);
    res.status(500).json({ success: false, error: error.message });
  }
});

module.exports = Router;