const admin = require('firebase-admin');
const path = require('path');

// Initialize Firebase Admin with service account
// IMPORTANT: Get this from Firebase Console > Project Settings > Service Accounts > Generate new private key
// Save the JSON file and set FIREBASE_SERVICE_ACCOUNT_PATH environment variable pointing to it

const serviceAccountPath = process.env.FIREBASE_SERVICE_ACCOUNT_PATH 
  ? path.resolve(process.env.FIREBASE_SERVICE_ACCOUNT_PATH)
  : path.resolve(__dirname, '../firebase-service-account.json');

try {
  const serviceAccount = require(serviceAccountPath);
  admin.initializeApp({
    credential: admin.credential.cert(serviceAccount),
  });
  console.log('✅ Firebase Admin initialized successfully');
} catch (error) {
  console.warn('⚠️ Firebase not configured. File path:', serviceAccountPath);
  console.warn('Error:', error.message);
  console.warn('Download service account key from: Firebase Console > Project Settings > Service Accounts > Generate new private key');
}

module.exports = admin;
