
const mysqlConnection = require('../../utils/database');




const Highly_interested = async (req, res) => {
    try {
        // Execute the SQL query to count unassigned leads with 'open' status
        const [rows] = await mysqlConnection.promise().query('SELECT COUNT(*) as T_Unassigned FROM leads_main WHERE status = \'open\'');

        // Extract the total count from the result
        const totalUnassignedLeads = rows[0].T_Unassigned;
        console.log("the total un assinged lead is:",totalUnassignedLeads)
        // Respond with the total count of unassigned leads
        res.status(200).json({
            success: true,
            message: 'Total unassigned leads fetched successfully',
            total_unsigned: totalUnassignedLeads,
        });
    } catch (error) {
        console.error('Error fetching total unassigned leads:', error);
        res.status(500).json({
            success: false,
            message: 'Error in fetching total unassigned leads',
            error: error.message,
        });
    }
};
//befire the filter remove code

// const highly_interested_table = async (req, res) => {
//   try {
//     const { id } = req.params; 
//     const {field,email,company} = req.query;
//     let [perm]= await mysqlConnection.promise().query(`
//     SELECT ut.permission_level AS permission, u.name, u.company_id AS company_id
//     FROM users_types ut 
//     JOIN users u ON u.user_type = ut.type where u.email=?`,[email])
//     let company_id;
 
//     company_id=perm[0].company_id;
//     if(company && ((perm[0].permission)>9)){
      
//       company_id=company
//     }
//   let leads;
// if(parseFloat(perm[0].permission)>=9)
//   {  [leads] = await mysqlConnection.promise().query(`
//       SELECT
//         main.id,
//         customer.full_name AS customer_name,
//         customer.mobile AS mobile,
//         project.name AS project_name,
//         project.status AS project_status,
//         interested_in.unit AS interested_in,
//         main.status,
//         main.view_dt,
//         main.user,
//         main.assigned_on,
//         main.assigned_to,
//         label.label AS label,
//         company.title AS company_title,
//         label.bg AS bg_color,
//         main.last_updated
//       FROM
//         leads_main AS main
//       INNER JOIN
//         leads_customers AS customer ON main.customer = customer.id
//       INNER JOIN
//         lead_projects AS project ON main.project = project.id
//       INNER JOIN
//         leads_labels AS label ON main.leads_label = label.id
//       INNER JOIN
//         companies AS company ON FIND_IN_SET(company.id, main.company_id) > 0
//       INNER JOIN
//         inventory_type AS interested_in ON main.interested_in = interested_in.id
//       WHERE
//         main.${field} = ? AND FIND_IN_SET(main.company_id, ?) > 0
//       ORDER BY main.last_updated DESC
//     `, [id,company_id]);

//      if (id==12 && field==="leads_label"){
//      [leads] = await mysqlConnection.promise().query(`
//       SELECT
//         main.id,
//         customer.full_name AS customer_name,
//         customer.mobile AS mobile,
//         project.name AS project_name,
//         project.status AS project_status,
//         interested_in.unit AS interested_in,
//         main.status,
//         main.view_dt,
//         main.user,
//         main.assigned_on,
//         main.assigned_to,
//         label.label AS label,
//         company.title AS company_title,
//         label.bg AS bg_color,
//         main.last_updated
//       FROM
//         leads_main AS main
//       INNER JOIN
//         leads_customers AS customer ON main.customer = customer.id
//       INNER JOIN
//         lead_projects AS project ON main.project = project.id
//       INNER JOIN
//         leads_labels AS label ON main.leads_label = label.id
//       INNER JOIN
//         companies AS company ON FIND_IN_SET(company.id, main.company_id) > 0
//       INNER JOIN
//         inventory_type AS interested_in ON main.interested_in = interested_in.id
//       WHERE
//         main.status = \'un_assigned\' AND FIND_IN_SET(main.company_id, ?) > 0
//       ORDER BY main.last_updated DESC
//     `,[company_id]);
//      }
//      if (id==11 && field==="leads_label"){
//        [leads] = await mysqlConnection.promise().query(`
//       SELECT
//         main.id,
//         customer.full_name AS customer_name,
//         customer.mobile AS mobile,
//         project.name AS project_name,
//         project.status AS project_status,
//         interested_in.unit AS interested_in,
//         main.status,
//         main.view_dt,
//         main.user,
//         main.assigned_on,
//         main.assigned_to,
//         label.label AS label,
//         company.title AS company_title,
//         label.bg AS bg_color,
//         main.last_updated
//       FROM
//         leads_main AS main
//       INNER JOIN
//         leads_customers AS customer ON main.customer = customer.id
//       INNER JOIN
//         lead_projects AS project ON main.project = project.id
//       INNER JOIN
//         leads_labels AS label ON main.leads_label = label.id
//       INNER JOIN
//         companies AS company ON FIND_IN_SET(company.id, main.company_id) > 0
//       INNER JOIN
//         inventory_type AS interested_in ON main.interested_in = interested_in.id
//       WHERE FIND_IN_SET(main.company_id, ?) > 0
//       ORDER BY main.last_updated DESC
//       `,[company_id]
//     );
//      }
//     }
//     else{
//       [leads] = await mysqlConnection.promise().query(`
//       SELECT
//         main.id,
//         customer.full_name AS customer_name,
//         customer.mobile AS mobile,
//         project.name AS project_name,
//         project.status AS project_status,
//         interested_in.unit AS interested_in,
//         main.status,
//         main.view_dt,
//         main.assigned_on,
//         main.assigned_to,
//         main.user,
//         label.label AS label,
//         company.title AS company_title,
//         label.bg AS bg_color,
//         main.last_updated
//       FROM
//         leads_main AS main
//       INNER JOIN
//         leads_customers AS customer ON main.customer = customer.id
//       INNER JOIN
//         lead_projects AS project ON main.project = project.id
//       INNER JOIN
//         leads_labels AS label ON main.leads_label = label.id
//       INNER JOIN
//         inventory_type AS interested_in ON main.interested_in = interested_in.id
//       INNER JOIN
//         companies AS company ON FIND_IN_SET(company.id, main.company_id) > 0
//       WHERE
//       main.assigned_to = ? AND main.${field} = ? AND FIND_IN_SET(main.company_id, ?) > 0
//       ORDER BY main.last_updated DESC
//     `, [perm[0].name,id,company_id]);
//     }

//     if (!leads.length) {
//       return res.status(200).json({
//         success: true,
//         message: 'No leads found',
//       });
//     }
  
//     leads = leads.map(lead => ({
//         ...lead,
//         permission: perm[0].permission
//       }));
  
//     // Respond with all leads information
//     res.status(200).json({
//       success: true,
//       message: 'All mached labels information fetched successfully',
//       leads: leads,
//     });
//   } catch (error) {
//     console.error('Error fetching table leads labels information:', error);
//     res.status(500).json({
//       success: false,
//       message: 'Error in fetching label leads information',
//       error: error.message,
//     });
//   }
// };

// working file beform user all leads
// const highly_interested_table = async (req, res) => {
//   try {
//     const { id } = req.params;
//     const { field, email, company } = req.query;

//     const page = 1; // default page internally
//     const limit = 50; // return 50 records max per request
//     const offset = (page - 1) * limit;

//     let [perm] = await mysqlConnection.promise().query(`
//       SELECT ut.permission_level AS permission, u.name, u.company_id AS company_id
//       FROM users_types ut 
//       JOIN users u ON u.user_type = ut.type WHERE u.email = ?`,
//       [email]
//     );

//     let company_id = perm[0].company_id;
//     if (company && (perm[0].permission > 9)) {
//       company_id = company;
//     }

//     let leads;

//     if (parseFloat(perm[0].permission) >= 9) {
//       [leads] = await mysqlConnection.promise().query(`
//         SELECT
//           main.id,
//           customer.full_name AS customer_name,
//           customer.mobile AS mobile,
//           project.name AS project_name,
//           project.status AS project_status,
//           interested_in.unit AS interested_in,
//           main.status,
//           main.view_dt,
//           main.user,
//           main.assigned_on,
//           main.assigned_to,
//           label.label AS label,
//           label.bg AS bg_color,
//           main.last_updated,
//           main.lead_pass
//         FROM leads_main AS main
//         INNER JOIN leads_customers AS customer ON main.customer = customer.id
//         INNER JOIN lead_projects AS project ON main.project = project.id
//         INNER JOIN leads_labels AS label ON main.leads_label = label.id
//         INNER JOIN inventory_type AS interested_in ON main.interested_in = interested_in.id
//         WHERE main.${field} = ?
//         ORDER BY main.last_updated DESC
//         LIMIT ? OFFSET ?`,
//         [id, limit, offset]
//       );

//       if (id == 12 && field === "leads_label") {
//         [leads] = await mysqlConnection.promise().query(`
//           SELECT
//             main.id,
//             customer.full_name AS customer_name,
//             customer.mobile AS mobile,
//             project.name AS project_name,
//             project.status AS project_status,
//             interested_in.unit AS interested_in,
//             main.status,
//             main.view_dt,
//             main.user,
//             main.assigned_on,
//             main.assigned_to,
//             label.label AS label,
//             label.bg AS bg_color,
//             main.last_updated,
//             main.lead_pass
//           FROM leads_main AS main
//           INNER JOIN leads_customers AS customer ON main.customer = customer.id
//           INNER JOIN lead_projects AS project ON main.project = project.id
//           INNER JOIN leads_labels AS label ON main.leads_label = label.id
//           INNER JOIN inventory_type AS interested_in ON main.interested_in = interested_in.id
//           WHERE main.status = 'un_assigned'
//           ORDER BY main.last_updated DESC
//           LIMIT ? OFFSET ?`,
//           [limit, offset]
//         );
//       }

//       if (id == 11 && field === "leads_label") {
//         [leads] = await mysqlConnection.promise().query(`
//           SELECT
//             main.id,
//             customer.full_name AS customer_name,
//             customer.mobile AS mobile,
//             project.name AS project_name,
//             project.status AS project_status,
//             interested_in.unit AS interested_in,
//             main.status,
//             main.view_dt,
//             main.user,
//             main.assigned_on,
//             main.assigned_to,
//             label.label AS label,
//             label.bg AS bg_color,
//             main.last_updated,
//             main.lead_pass
//           FROM leads_main AS main
//           INNER JOIN leads_customers AS customer ON main.customer = customer.id
//           INNER JOIN lead_projects AS project ON main.project = project.id
//           INNER JOIN leads_labels AS label ON main.leads_label = label.id
//           INNER JOIN inventory_type AS interested_in ON main.interested_in = interested_in.id
//           ORDER BY main.last_updated DESC
//           LIMIT ? OFFSET ?`,
//           [limit, offset]
//         );
//       }

//     } else {
//       [leads] = await mysqlConnection.promise().query(`
//         SELECT
//           main.id,
//           customer.full_name AS customer_name,
//           customer.mobile AS mobile,
//           project.name AS project_name,
//           project.status AS project_status,
//           interested_in.unit AS interested_in,
//           main.status,
//           main.view_dt,
//           main.assigned_on,
//           main.assigned_to,
//           main.user,
//           label.label AS label,
//           label.bg AS bg_color,
//           main.last_updated,
//           main.lead_pass
//         FROM leads_main AS main
//         INNER JOIN leads_customers AS customer ON main.customer = customer.id
//         INNER JOIN lead_projects AS project ON main.project = project.id
//         INNER JOIN leads_labels AS label ON main.leads_label = label.id
//         INNER JOIN inventory_type AS interested_in ON main.interested_in = interested_in.id
//         WHERE main.assigned_to = ? AND main.${field} = ?
//         ORDER BY main.last_updated DESC
//         LIMIT ? OFFSET ?`,
//         [perm[0].name, id, limit, offset]
//       );
//     }

//     if (!leads.length) {
//       return res.status(200).json({
//         success: true,
//         message: 'No leads found',
//       });
//     }

//     leads = leads.map(lead => ({
//       ...lead,
//       permission: perm[0].permission
//     }));

//     res.status(200).json({
//       success: true,
//       message: 'All matched labels information fetched successfully',
//       leads: leads
//     });
//   } catch (error) {
//     console.error('Error fetching table leads labels information:', error);
//     res.status(500).json({
//       success: false,
//       message: 'Error in fetching label leads information',
//       error: error.message,
//     });
//   }
// };

// const highly_interested_table = async (req, res) => {
//   try {
//     const rawId = req.params.id;
//     const { field, email } = req.query;

//     // allowlist
//     const FIELD_MAP = {
//       leads_label: '`main`.`leads_label`',
//       project: '`main`.`project`',
//       interested_in: '`main`.`interested_in`',
//       status: '`main`.`status`',
//       user: '`main`.`user`',
//       assigned_to: '`main`.`assigned_to`',
//     };
//     if (!FIELD_MAP[field]) {
//       return res.status(400).json({ success: false, message: 'Invalid field' });
//     }

//     // user / permission
//     const [permRows] = await mysqlConnection.promise().query(
//       `
//       SELECT ut.permission_level AS permission, u.name
//       FROM users_types ut
//       JOIN users u ON u.user_type = ut.type
//       WHERE u.email = ?
//       LIMIT 1
//       `,
//       [email]
//     );
//     if (!permRows?.length) {
//       return res.status(404).json({ success: false, message: 'User not found' });
//     }
//     const permission = Number(permRows[0].permission) || 0;
//     const userName = permRows[0].name;

//     // where conditions
//     const where = [];
//     const params = [];

//     const isAllLeadsBucket = field === 'leads_label' && String(rawId) === '11';
//     const isUnassignedBucket = field === 'leads_label' && String(rawId) === '12';

//     const stringFields = new Set(['status', 'user', 'assigned_to']);
//     const filterValue = stringFields.has(field) ? String(rawId) : Number(rawId);

//     if (permission >= 9) {
//       if (isAllLeadsBucket) {
//         // no extra filter
//       } else if (isUnassignedBucket) {
//         where.push('(`main`.`status` = ? OR `main`.`assigned_to` IS NULL OR `main`.`assigned_to` = \'\')');
//         params.push('un_assigned');
//       } else {
//         where.push(`${FIELD_MAP[field]} = ?`);
//         params.push(filterValue);
//       }
//     } else {
//       if (isUnassignedBucket) {
//         return res.status(200).json({
//           success: true, message: 'No leads found', leads: [], total: 0
//         });
//       }
//       where.push('`main`.`assigned_to` = ?');
//       params.push(userName);
//       if (!isAllLeadsBucket) {
//         where.push(`${FIELD_MAP[field]} = ?`);
//         params.push(filterValue);
//       }
//     }

//     // base query parts
//     const baseFrom = `
//       FROM leads_main AS main
//       LEFT JOIN leads_customers AS customer  ON main.customer      = customer.id
//       LEFT JOIN lead_projects   AS project   ON main.project       = project.id
//       LEFT JOIN leads_labels    AS label     ON main.leads_label   = label.id
//       LEFT JOIN inventory_type  AS interested_in ON main.interested_in = interested_in.id
//     `;
//     const whereSql = where.length ? `WHERE ${where.join(' AND ')}` : '';
//     const orderBy = 'ORDER BY main.last_updated DESC, main.id DESC';

//     // count query
//     const [countRows] = await mysqlConnection.promise().query(
//       `SELECT COUNT(*) AS total FROM leads_main AS main ${whereSql.replaceAll('`main`.', 'main.')}`,
//       params
//     );
//     const total = Number(countRows?.[0]?.total || 0);

//     if (total === 0) {
//       return res.status(200).json({
//         success: true, message: 'No leads found', leads: [], total
//       });
//     }

//     // main data query (⚡️ no LIMIT applied)
//     const sql = `
//       SELECT
//         main.id,
//         customer.full_name      AS customer_name,
//         customer.mobile         AS mobile,
//         project.name            AS project_name,
//         project.status          AS project_status,
//         interested_in.unit      AS interested_in,
//         main.status,
//         main.view_dt,
//         main.user,
//         main.assigned_on,
//         main.assigned_to,
//         label.label             AS label,
//         label.bg                AS bg_color,
//         main.last_updated,
//         main.lead_pass
//       ${baseFrom}
//       ${whereSql}
//       ${orderBy}
//     `;

//     const [rows] = await mysqlConnection.promise().query(sql, params);
//     const leads = rows.map(r => ({ ...r, permission }));

//     return res.status(200).json({
//       success: true,
//       message: 'All matched labels information fetched successfully',
//       leads,
//       total
//     });
//   } catch (error) {
//     console.error('Error fetching table leads labels information:', error);
//     return res.status(500).json({
//       success: false,
//       message: 'Error in fetching label leads information',
//       error: error.message,
//     });
//   }
// };
// paganition

//before pagination
// const highly_interested_table = async (req, res) => {
//   try {
//     // paging
//     const page = Math.max(1, parseInt(req.query.page || '1', 10));
//     const pageSizeRaw = parseInt(req.query.pageSize || '500', 10);
// const pageSize = Math.min(1000, Math.max(1, isNaN(pageSizeRaw) ? 50 : pageSizeRaw));

//     const offset = (page - 1) * pageSize;

//     const rawId = req.params.id; // don't force Number; may be string for some fields
//     const { field, email } = req.query;

//     // Allowlist + explicit column map (prevents SQL injection & quoting issues)
//     const FIELD_MAP = {
//       leads_label: '`main`.`leads_label`',
//       project: '`main`.`project`',
//       interested_in: '`main`.`interested_in`',
//       status: '`main`.`status`',
//       user: '`main`.`user`',
//       assigned_to: '`main`.`assigned_to`',
//     };

//     if (!FIELD_MAP[field]) {
//       return res.status(400).json({ success: false, message: 'Invalid field' });
//     }

//     // Get permission + user name
//     const [permRows] = await mysqlConnection
//       .promise()
//       .query(
//         `
//         SELECT ut.permission_level AS permission, u.name
//         FROM users_types ut
//         JOIN users u ON u.user_type = ut.type
//         WHERE u.email = ?
//         LIMIT 1
//         `,
//         [email]
//       );

//     if (!permRows || permRows.length === 0) {
//       return res.status(404).json({ success: false, message: 'User not found' });
//     }
//     const permission = Number(permRows[0].permission) || 0;
//     const userName = permRows[0].name;

//     // Build WHERE safely + params
//     const where = [];
//     const params = [];

//     // Special buckets for leads_label
//     const isAllLeadsBucket = field === 'leads_label' && String(rawId) === '11';
//     const isUnassignedBucket = field === 'leads_label' && String(rawId) === '12';

//     // For fields that are strings in DB, keep the rawId as string; else use number
//     const stringFields = new Set(['status', 'user', 'assigned_to']);
//     const filterValue = stringFields.has(field) ? String(rawId) : Number(rawId);

//     if (permission >= 9) {
//       // Admins: see everything unless filtered
//       if (isAllLeadsBucket) {
//         // no extra filter
//       } else if (isUnassignedBucket) {
//         // Unify "unassigned": catch status OR missing/blank assignment
//         where.push(`( \`main\`.\`status\` = ? OR \`main\`.\`assigned_to\` IS NULL OR \`main\`.\`assigned_to\` = '' )`);
//         params.push('un_assigned');
//       } else {
//         where.push(`${FIELD_MAP[field]} = ?`);
//         params.push(filterValue);
//       }
//     } else {
//       // Non-admins: scoped to their own leads
//       if (isUnassignedBucket) {
//         // Business rule: hide unassigned for non-admins
//         return res.status(200).json({
//           success: true,
//           message: 'No leads found',
//           leads: [],
//           page,
//           pageSize,
//           total: 0,
//           hasMore: false,
//         });
//       }

//       // Always scope to assignee
//       where.push('`main`.`assigned_to` = ?');
//       params.push(userName);

//       if (!isAllLeadsBucket) {
//         where.push(`${FIELD_MAP[field]} = ?`);
//         params.push(filterValue);
//       }
//     }

//     // Base selects – LEFT JOIN to avoid losing rows (count/list mismatch)
//     const baseFrom = `
//       FROM leads_main AS main
//       LEFT JOIN leads_customers AS customer  ON main.customer      = customer.id
//       LEFT JOIN lead_projects   AS project   ON main.project       = project.id
//       LEFT JOIN leads_labels    AS label     ON main.leads_label   = label.id
//       LEFT JOIN inventory_type  AS interested_in ON main.interested_in = interested_in.id
//     `;

//     const whereSql = where.length ? `WHERE ${where.join(' AND ')}` : '';

//     // COUNT(*) uses the SAME filters on main to keep numbers consistent
//     const [countRows] = await mysqlConnection.promise().query(
//       `SELECT COUNT(*) AS total
//       FROM leads_main AS main
//       ${whereSql.replaceAll('`main`.', 'main.')}
//       `,
//       params
//     );
//     const total = Number(countRows?.[0]?.total || 0);

//     if (total === 0) {
//       return res.status(200).json({
//         success: true,
//         message: 'No leads found',
//         leads: [],
//         page,
//         pageSize,
//         total: 0,
//         hasMore: false,
//       });
//     }

//     // Main page query with LEFT JOINs and pagination
//     const [rows] = await mysqlConnection.promise().query(
//       `
//       SELECT
//         main.id,
//         customer.full_name      AS customer_name,
//         customer.mobile         AS mobile,
//          customer.city      AS city,
//         project.name            AS project_name,
//         project.status          AS project_status,
//         interested_in.unit      AS interested_in,
//         main.status,
//         main.view_dt,
//         main.user,
//         main.assigned_on,
//         main.assigned_to,
//         label.label             AS label,
//         label.bg                AS bg_color,
//         main.last_updated,
//         main.lead_pass
//       ${baseFrom}
//       ${whereSql}
//       ORDER BY main.last_updated DESC
//       LIMIT ? OFFSET ?
//       `,
//       [...params, pageSize, offset]
//     );

//     // Attach permission once per record (frontend probably doesn’t need it per-row, but keeping your shape)
//     const leads = rows.map((lead) => ({ ...lead, permission }));

//     return res.status(200).json({
//       success: true,
//       message: 'All matched labels information fetched successfully',
//       leads,
//       page,
//       pageSize,
//       total,
//       hasMore: offset + leads.length < total,
//     });
//   } catch (error) {
//     console.error('Error fetching table leads labels information:', error);
//     return res.status(500).json({
//       success: false,
//       message: 'Error in fetching label leads information',
//       error: error.message,
//     });
//   }
// };

const highly_interested_table = async (req, res) => {
  try {
    const rawId = req.params.id;

    // accept field/email as before + fix query params: limit/offset
    const {
      field,
      email,
      limit: limitParam,       // ✅ now honoring `limit`
      offset: offsetParam = 0, // ✅ new: pagination offset
    } = req.query;

    // allowlist for fields
    const FIELD_MAP = {
      leads_label: '`main`.`leads_label`',
      project: '`main`.`project`',
      interested_in: '`main`.`interested_in`',
      status: '`main`.`status`',
      user: '`main`.`user`',
      assigned_to: '`main`.`assigned_to`',
    };
    if (!FIELD_MAP[field]) {
      return res.status(400).json({ success: false, message: 'Invalid field' });
    }

    // user permission
    const [permRows] = await mysqlConnection.promise().query(
      `
      SELECT ut.permission_level AS permission, u.name
      FROM users_types ut
      JOIN users u ON u.user_type = ut.type
      WHERE u.email = ?
      LIMIT 1
      `,
      [email]
    );

    if (!permRows?.length) {
      return res.status(404).json({ success: false, message: 'User not found' });
    }

    const permission = Number(permRows[0].permission) || 0;
    const userName = permRows[0].name;

    // where conditions
    const where = [];
    const params = [];

    const isAllLeadsBucket = field === 'leads_label' && String(rawId) === '11';
    const isUnassignedBucket = field === 'leads_label' && String(rawId) === '12';

    const stringFields = new Set(['status', 'user', 'assigned_to']);
    const filterValue = stringFields.has(field) ? String(rawId) : Number(rawId);

    if (permission >= 9) {
      if (isAllLeadsBucket) {
        // no extra filter
      } else if (isUnassignedBucket) {
        where.push('(`main`.`status` = ? OR `main`.`assigned_to` IS NULL OR `main`.`assigned_to` = \'\')');
        params.push('un_assigned');
      } else {
        where.push(`${FIELD_MAP[field]} = ?`);
        params.push(filterValue);
      }
    } else {
      if (isUnassignedBucket) {
        return res.status(200).json({ success: true, message: 'No leads found', leads: [], total: 0 });
      }
      where.push('`main`.`assigned_to` = ?');
      params.push(userName);
      if (!isAllLeadsBucket) {
        where.push(`${FIELD_MAP[field]} = ?`);
        params.push(filterValue);
      }
    }

    // base query parts
    const baseFrom = `FROM leads_main AS main
      LEFT JOIN leads_customers AS customer  ON main.customer      = customer.id
      LEFT JOIN lead_projects   AS project   ON main.project       = project.id
      LEFT JOIN leads_labels    AS label     ON main.leads_label   = label.id
      LEFT JOIN inventory_type  AS interested_in ON main.interested_in = interested_in.id`;

    const whereSql = where.length ? `WHERE ${where.join(' AND ')}` : '';
    const orderBy = 'ORDER BY main.last_updated DESC, main.id DESC';

    // total count
    // (keep alias names simple in count query to avoid backtick replace issues)
    const [countRows] = await mysqlConnection.promise().query(
      `SELECT COUNT(*) AS total FROM leads_main AS main ${whereSql.replaceAll('`main`.', 'main.')}`,
      params
    );
    const total = Number(countRows?.[0]?.total || 0);

    if (total === 0) {
      return res.status(200).json({ success: true, message: 'No leads found', leads: [], total });
    }

    // pagination
    const requestedLimit = Number(limitParam) || 300;
    const offset = Number(offsetParam) || 0;
    const fetchLimit = Math.max(0, Math.min(requestedLimit, total - offset));

    if (fetchLimit <= 0) {
      return res.status(200).json({ success: true, message: 'No more leads', leads: [], total });
    }

    // main page fetch (WITH customer id so we can attach history)
    const sql = `
      SELECT
        main.id,
        main.customer            AS customer_id,
        customer.full_name       AS customer_name,
        customer.mobile          AS mobile,
        customer.city            AS city,
        project.name             AS project_name,
        project.status           AS project_status,
        interested_in.unit       AS interested_in,
        main.status,
        main.view_dt,
        main.user,
        main.assigned_on,
        main.assigned_to,
        label.label              AS label,
        label.bg                 AS bg_color,
        main.last_updated,
        main.lead_pass
      ${baseFrom}
      ${whereSql}
      ${orderBy}
      LIMIT ? OFFSET ?
    `;

    const [rows] = await mysqlConnection.promise().query(sql, [...params, fetchLimit, offset]);

    // ====== HISTORY: fetch all leads for the same customers and attach ======
    const customerIds = [...new Set(rows.map(r => r.customer_id).filter(Boolean))];
    let historyMap = new Map();

    if (customerIds.length > 0) {
      const placeholders = customerIds.map(() => '?').join(',');
      const historySql = `
        SELECT
          h.id,
          h.customer                              AS customer_id,
          h.project                               AS project_id,
          hp.name                                 AS project_name,
          h.leads_label                           AS leads_label_id,
          lb.label                                AS leads_label,
          lb.bg                                   AS leads_label_bg,
          h.status,
          h.assigned_to,
          h.user,
          h.last_updated,
          h.assigned_on
        FROM leads_main h
        LEFT JOIN lead_projects hp ON hp.id = h.project
        LEFT JOIN leads_labels  lb ON lb.id = h.leads_label
        WHERE h.customer IN (${placeholders})
        ORDER BY h.last_updated DESC, h.id DESC
      `;
      const [historyRows] = await mysqlConnection.promise().query(historySql, customerIds);

      historyMap = historyRows.reduce((acc, r) => {
        const arr = acc.get(r.customer_id) || [];
        arr.push({
          id: r.id,
          project_id: r.project_id,
          project_name: r.project_name,
          leads_label_id: r.leads_label_id,
          leads_label: r.leads_label,
          leads_label_bg: r.leads_label_bg,
          status: r.status,
          assigned_to: r.assigned_to,
          user: r.user,
          last_updated: r.last_updated,
          assigned_on: r.assigned_on,
        });
        acc.set(r.customer_id, arr);
        return acc;
      }, new Map());
    }

    // attach history and permission
    const leads = rows.map(r => ({
      ...r,
      permission,
      history: historyMap.get(r.customer_id) || [],
    }));

    return res.status(200).json({
      success: true,
      message: 'All matched labels information fetched successfully',
      leads,
      total
    });

  } catch (error) {
    console.error('Error fetching table leads labels information:', error);
    return res.status(500).json({
      success: false,
      message: 'Error in fetching label leads information',
      error: error.message,
    });
  }
};



const SpecificTeamMemberLeads = async (req, res) => {
  try {
    const { id, id1 } = req.params;
    const field = req.query.field;
    
    // Get user information
    const [user] = await mysqlConnection.promise().query(
      `SELECT name FROM users WHERE id = ?`,
      [id1]
    );

    if (!user || !user.length) {
      return res.status(404).json({
        success: false,
        message: 'User not found',
      });
    }

    let leads;
    const baseQuery = `
      SELECT
        main.id,
        customer.full_name AS customer_name,
        customer.mobile AS mobile,
        project.name AS project_name,
        project.status AS project_status,
        interested_in.unit AS interested_in, 
        main.status,
        main.view_dt,
        main.user,
        main.assigned_on,
        label.label AS label,
        label.bg AS bg_color
      FROM
        leads_main AS main
      INNER JOIN leads_customers AS customer ON main.customer = customer.id
      INNER JOIN lead_projects AS project ON main.project = project.id
      INNER JOIN leads_labels AS label ON main.leads_label = label.id
      INNER JOIN inventory_type AS interested_in ON main.interested_in = interested_in.id
    `;

    // Special cases for unassigned leads (id=12) and all leads (id=11)
    if (id == 12 && field === "leads_label") {
      [leads] = await mysqlConnection.promise().query(
        `${baseQuery} WHERE main.status = 'un_assigned'`
      );
    } 
    else if (id == 11 && field === "leads_label") {
      [leads] = await mysqlConnection.promise().query(baseQuery);
    } 
    else {
      // Default case - filter by assigned_to and leads_label
      [leads] = await mysqlConnection.promise().query(
        `${baseQuery} WHERE main.assigned_to = ? AND main.leads_label = ?`,
        [user[0].name, id]
      );
    }

    if (!leads.length) {
      return res.status(200).json({
        success: true,
        message: 'No leads found',
        leads: []
      });
    }

    res.status(200).json({
      success: true,
      message: 'Leads information fetched successfully',
      leads: leads,
    });
  } catch (error) {
    console.error('Error fetching leads:', error);
    res.status(500).json({
      success: false,
      message: 'Error in fetching leads information',
      error: error.message,
    });
  }
};

  const GetLeadFromId = async (req, res) => {
    try {
      const { id } = req.params;
      const [leads] = await mysqlConnection.promise().query(`
        SELECT
          main.id,
          customer.full_name AS customer_name,
          customer.email AS email,
          customer.mobile AS mobile,
          customer.city AS city,
          project.name AS project_name,
          project.status AS project_status,
          project.category AS category,
          interested_in.unit AS interested_in,
          main.id AS main_id,
          main.assigned_on,
          main.status,
          main.view_dt,
          main.campaign_name,
          main.campaign_type,
          main.assigned_to,
          main.campaign_type,
          main.investment_time,
          main.investment_budget,
          main.user,
          label.label AS label,
          label.bg AS bg_color,
          label.color AS color
        FROM
          leads_main AS main
        INNER JOIN
          leads_customers AS customer ON main.customer = customer.id
        LEFT JOIN
          lead_projects AS project ON main.project = project.id
        INNER JOIN
          leads_labels AS label ON main.leads_label = label.id
        LEFT JOIN
          inventory_type  AS interested_in ON main.interested_in = interested_in.id
        WHERE main.id = ?;
      `, [id]);
  
      if (!leads.length) {
        return res.status(404).json({
          success: false,
          message: 'No leads found',
        });
      }
    
      // Respond with all leads information
      res.status(200).json({
        success: true,
        message: ' leads information fetched successfully',
        leads: leads,
      });
    } catch (error) {
      console.error('Error fetching leads information:', error);
      res.status(500).json({
        success: false,
        message: 'Error in fetching leads information',
        error: error.message,
      });
    }
  };
  
//All customer data
// 
const AllCustomers = async (req, res) => {
  try {
    const email = req.params.user;

    // Simple pagination (keep your defaults)
    const page = 1;
    const limit = 50;
    const offset = (page - 1) * limit;

    // 1) Fetch user
    const [userRows] = await mysqlConnection.promise().query(
      'SELECT user_type, name FROM users WHERE email = ?',
      [email]
    );

    if (!userRows.length) {
      return res.status(404).json({ success: false, message: 'User not found' });
    }

    const { user_type, name } = userRows[0];

    // 2) Check permission level
    const [typeRows] = await mysqlConnection.promise().query(
      'SELECT permission_level FROM users_types WHERE type = ?',
      [user_type]
    );

    const hasHighPermission = typeRows.some(row => row.permission_level > 8);

    // 3) If high permission, return ALL customers (joined view)
    if (hasHighPermission) {
      const [leads] = await mysqlConnection.promise().query(
        `
        SELECT
          main.id,
          customer.full_name AS customer_name,
          customer.mobile AS mobile,
          project.name AS project_name,
          project.status AS project_status,
          interested_in.unit AS interested_in,
          customer.email AS email,
          customer.city AS city,
          customer.country AS country,
          main.status,
          main.view_dt,
          main.assigned_on,
          main.assigned_to,
          main.user,
          label.label AS label,
          label.bg AS bg_color
        FROM leads_customers AS customer
        LEFT JOIN leads_main AS main ON customer.id = main.customer
        LEFT JOIN lead_projects AS project ON main.project = project.id
        LEFT JOIN leads_labels AS label ON main.leads_label = label.id
        LEFT JOIN inventory_type AS interested_in ON main.interested_in = interested_in.id
        LIMIT ? OFFSET ?
        `,
        [limit, offset]
      );

      return res.status(200).json({
        success: true,
        message: leads.length ? 'All Customers information fetched successfully' : 'No customers found',
        leads,
      });
    }

    // 4) Regular permissions: fetch assigned customer IDs
    const [assignedCustomers] = await mysqlConnection.promise().query(
      'SELECT customer AS customer_id FROM leads_main WHERE assigned_to = ?',
      [name]
    );

    if (!assignedCustomers.length) {
      return res.status(200).json({
        success: true,
        message: 'No customers found',
        leads: [],
      });
    }

     let customerIds = assignedCustomers.map(c => c.customer_id);

// (optional) dedupe + ensure numbers
customerIds = Array.from(new Set(
  customerIds.map(Number).filter(Number.isFinite)
));

let sql = `
  SELECT
    id,
    full_name AS customer_name,
    mobile,
    whatsapp,
    email,
    job_title,
    city,
    type,
    country,
    dt,
    user AS assigned_to
  FROM leads_customers
  WHERE `;

let params = [];

if (customerIds.length > 0) {
  sql += `(id IN (?) OR user = ?)`;
  params.push(customerIds, name);
} else {
  sql += `user = ?`;
  params.push(name);
}

const [customers] = await mysqlConnection.promise().query(sql, params);



    return res.status(200).json({
      success: true,
      message: customers.length ? 'Customer information fetched successfully' : 'No customers found',
      leads: customers,
    });
  } catch (error) {
    console.error('Error fetching related Customers information:', error);
    return res.status(500).json({
      success: false,
      message: 'Error in fetching related Customers information',
      error: error.message,
    });
  }
};


//label for header
const HeaderLabel = async (req, res) => {
  try {
    const { id } = req.params;
    const [leads] = await mysqlConnection.promise().query(`
    SELECT label from leads_labels where id = ?;
    `, [id]);

    if (!leads.length) {
      return res.status(404).json({
        success: false,
        message: 'No Header found',
      });
    }

    // Respond with all leads information
    res.status(200).json({
      success: true,
      message: 'Header label information fetched successfully',
      header: leads,
    });
  } catch (error) {
    console.error('Error fetching header label information:', error);
    res.status(500).json({
      success: false,
      message: 'Error in fetching header label information',
      error: error.message,
    });
  }
};


module.exports = {Highly_interested,highly_interested_table,GetLeadFromId,AllCustomers,HeaderLabel, SpecificTeamMemberLeads};